<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template name="publishtest">

  <xsl:choose>
    <xsl:when test="contains(ancestor-or-self::*/@name, '@') or
                    contains(ancestor-or-self::*/@name, '$')">
      <!--
      <xsl:message>
        Not publishing: <xsl:value-of select="@name"/>
    </xsl:message>
    -->
      <xsl:text>no</xsl:text>
    </xsl:when>

    <xsl:when test="self::namespace">
      
      <xsl:choose>
        <xsl:when test="(@name='Borland.Data.Provider' or
                        @name='Borland.Data.Common' or
                        @name='Borland.Data.Schema' or
                        @name='Borland.Data.Web' or
                        @name='Borland.Delphi.System' or
                        @name='Borland.Eco.UmlRt' or
                        @name='Borland.Eco.Subscription' or
                        @name='Borland.Eco.ObjectRepresentation' or
                        @name='Borland.Eco.Services' or
                        @name='Borland.Eco.WinForm' or
                        @name='Borland.Eco.AutoContainers' or
                        @name='Borland.Eco.ObjectSpace' or
                        @name='Borland.Eco.Handles') or
                        @name='Borland.Eco.Persistence' or
                        @name='Borland.Eco.Persistence.Configuration' or
                        @name='Borland.Eco.Persistence.DatabaseConfig' or
                        @name='Borland.Eco.Persistence.Default' or
                        contains(@name, '.Vcl.') or
                        contains(@name, 'Borland.Db')">
          <xsl:text>yes</xsl:text>
        </xsl:when> <!-- namespace -->
        
        <xsl:otherwise>
          <!--
               <xsl:message>
            Not publishing <xsl:value-of select="@name"/>
          </xsl:message>
          -->
          <xsl:text>no</xsl:text>
        </xsl:otherwise>
        
      </xsl:choose>
    </xsl:when>  
    
    <xsl:when test="self::class | self::helper">
      
      <xsl:variable name="namespacepublished">
        <xsl:for-each select="../../namespace[1]">
          <xsl:call-template name="publishtest"/>
        </xsl:for-each>
      </xsl:variable>
      
      <xsl:choose>
        <xsl:when test="normalize-space($namespacepublished/text())!='no'">
          <xsl:choose>
            <xsl:when test="not (contains(@name,'@') or 
                                 contains(@name,'$')) and 
                            not (contains(@name,'ADONETConnector')) and
                            ((./@name = 'ISQLConnection' or
                            ./@name = 'ISQLCommand' or
                            ./@name = 'ISQLCursor' or
                            ./@name = 'ISQLMetaData' or
                            ./@name = 'ISQLResolver' or
                            ./@name = 'ISQLDataSource' or
                            ./@name = 'BdpConnection' or
                            ./@name = 'BdpCommand' or
                            ./@name = 'BdpParameter' or
                            ./@name = 'BdpParameterCollection' or
                            ./@name = 'BdpDataReader' or
                            ./@name = 'BdpDataAdapter' or
                            ./@name = 'BdpTransaction' or
                            ./@name = 'BdpException' or
                            ./@name = 'BdpError' or
                            ./@name = 'BdpErrorCollection' or
                            ./@name = 'BdpCommandBuilder') or
                            (contains(../@name, 
                              'Borland.Eco') and 
                            not(./@name = 'DisplayQueue') and
                            not(./@name = 'ElementConverter') and
                            not(./@name = 'Unit') and
                            not(./@name = 'TypeFinderDelegate') and
                            not(./@name = 'AbstractCondition')) or
                            contains(../@name, 'Borland.Vcl') or
                            contains(../@name, 'Borland.Delphi') or
                            contains(../@name, 'Borland.Data.Web'))">
              <xsl:text>yes</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>no</xsl:text>
            </xsl:otherwise>
              
          </xsl:choose>

            
        </xsl:when>
        <xsl:otherwise>
          <!--          <xsl:message>
            Not publishing <xsl:value-of select="@name"/>
          </xsl:message>-->
          <xsl:text>no</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
      
    </xsl:when> <!-- class -->
    
    <xsl:when test="self::enum">
      
      <xsl:variable name="namespacepublished">
        <xsl:for-each select="../../namespace[1]">
          <xsl:call-template name="publishtest"/>
        </xsl:for-each>
      </xsl:variable>
      
      <xsl:choose>
        <xsl:when test="normalize-space($namespacepublished/text())!='no'">
          <xsl:choose>
            <xsl:when test="not(@name='TraceLevel') and
                            not(@name='BdpOptions') and
                            not(@name='ColumnListType')
                            ">
              <xsl:text>yes</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <!--          <xsl:message>
            Not publishing <xsl:value-of select="@name"/>
          </xsl:message>-->
              <xsl:text>no</xsl:text>
            </xsl:otherwise>
          </xsl:choose>

        </xsl:when>
        <xsl:otherwise>
          <!--          <xsl:message>
            Not publishing <xsl:value-of select="@name"/>
          </xsl:message>-->

          <xsl:text>no</xsl:text>
        </xsl:otherwise>
      </xsl:choose>

    </xsl:when> <!-- enum -->


    <xsl:when test="self::function or self::procedure or self::constructor or self::destructor">
      
      <xsl:variable name="namespacepublished">
        <xsl:for-each select="../../namespace[1]">
          <xsl:call-template name="publishtest"/>
        </xsl:for-each>
      </xsl:variable>
      
      <xsl:variable name = "name" select = "@name"/>
      <xsl:choose>
        <xsl:when test="normalize-space($namespacepublished/text())!='no'">
          <xsl:choose>
            <!-- TODO: make sure we aren't losing anything when we
                 exclude all procedures with declaring interfaces -->

            <!-- also stopping methods which are generated, with name of a
                 property preceded by set_ or get_, when there is a
                 declared setter or getter -->
            <xsl:when test="not (@declaring_interface) and

                            not (contains($name,'$')) and

                            not (contains($name,'@')) and

                            not (contains($name,'.')) and 

                            not (../property[@write=$name]
                            | ../property [@read = $name]
                            | ../event[@add=$name]
                            | ../event [@remove = $name]
                            | ../event[@read=$name]
                            | ../event [@write = $name]) and

                            not (@generated and  
                            ../property[@write!=$name and 
                              $name=concat('set_',@name)]) and
                            not (@generated and  
                            ../property[@read!=$name and 
                              $name=concat('get_',@name)]) and
                            not (@generated and  
                            ../event[@add!=$name or 
                              $name=concat('add_',@name)]) and
                            not (@generated and  
                            ../event[@remove!=$name or 
                              $name=concat('remove_',@name)]) and
                            not (@generated and  
                            ../event[@write!=$name and 
                              $name=concat('set_',@name)]) and
                            not (@generated and  
                            ../event[@read!=$name and 
                              $name=concat('get_',@name)])">
              <xsl:text>yes</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <!--          <xsl:message>
            Not publishing <xsl:value-of select="@name"/>
          </xsl:message>-->

              <xsl:text>no</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <!--          <xsl:message>
            Not publishing <xsl:value-of select="@name"/>
          </xsl:message>-->

          <xsl:text>no</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>


    <!-- note: we can assume the class is published if we made it this far! -->
    <xsl:when test = "self::event | self::property">
      <xsl:choose>
        <xsl:when test="not (contains(@name,'$')) and
                        not (contains(@name,'@')) and
                        not (contains(@name,'.'))">
          <xsl:text>yes</xsl:text>  
        </xsl:when>
        <xsl:otherwise>
          <!--          <xsl:message>
            Not publishing <xsl:value-of select="@name"/>
          </xsl:message>-->

          <xsl:text>no</xsl:text>                    
        </xsl:otherwise>
      </xsl:choose>

    </xsl:when>

    <!-- the following is not necessary because we are allowing events without add and remove methods!
         <xsl:variable name="add">
           <xsl:choose>
             <xsl:when test = "@add">
               <xsl:value-of select = "@add"/>
               </xsl:when>
               <xsl:otherwise>
                 <xsl:value-of select = "concat('add_',@name)"/>
                 </xsl:otherwise>
               </xsl:choose>
             </xsl:variable>
             <xsl:variable name="remove">
               <xsl:choose>
                 <xsl:when test = "@remove">
                   <xsl:value-of select = "@remove"/>
                   </xsl:when>
                   <xsl:otherwise>
                     <xsl:value-of select = "concat('remove_',@name)"/>
                     </xsl:otherwise>        
                   </xsl:choose>
                 </xsl:variable>

      <xsl:choose>
        <xsl:when test="../procedure[@name=$add] 
                        |../function[@name=$add]
                        |../procedure[@name = $remove] 
                        |../function[@name=$remove]">
          <xsl:text>yes</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:message>Warning: event add/remove methods not found in publishtest: <xsl:value-of select="ancestor::class/@name | ancestor::interface/@name"/>.<xsl:value-of select="@name"/> - not publishing!!
          </xsl:message>
          <xsl:text>no</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
      -->
    
    <xsl:when test="self::members">
      <!--          <xsl:message>
            Not publishing <xsl:value-of select="@name"/>
          </xsl:message>-->

      <xsl:text>no</xsl:text>
    </xsl:when>

    <xsl:otherwise>
            
      <xsl:variable name="namespacepublished">
        <xsl:for-each select="ancestor::namespace[1]">
          <xsl:call-template name="publishtest"/>
        </xsl:for-each>
      </xsl:variable>
      
      <xsl:choose>
        <xsl:when test="normalize-space($namespacepublished/text())!='no'">
          <xsl:text>yes</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <!--          <xsl:message>
            Not publishing <xsl:value-of select="@name"/>
          </xsl:message>-->
          <xsl:text>no</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
      
    </xsl:otherwise>
  
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>